/*
**********************************************************************************	
* Title:						Discretix NVS Debug Source file						 					
*																			
* Filename:						nvs_debug.c															
*																			
* Project, Target, subsystem:	NVS , Debug 
* 
* Created:						17.07.2008														
*
* Modified:						17.07.2008										
*
* \Author						Miri S														
*																			
* \Remarks						Copyright (C) 2008 by Discretix Technologies Ltd.     			
*  								All Rights reserved											
**********************************************************************************/
#include "nvs_debug.h"

#ifdef NVS_DEBUG_MODE_ENABLED
	/*----------- External include files ----------------------------------------*/	
	/*----------- Local include files -------------------------------------------*/		
	/*----------- Global Data declarations --------------------------------------*/

    NVSDebugParams_t g_nvsDebugParams;

	/*----------- Local function declarations -----------------------------------*/
	/*---------------------------------------------------------------------------*/
	  
	/*---------------------------------------------------------------------------*/
	/*               DEBUG FUNCTIONS                                             */
	/*---------------------------------------------------------------------------*/
    
    
    /**************************************************************************
    Function: NVS_DebugStart
    ***************************************************************************/    
    DxError_t NVS_DebugStart(DxError_t        aErrorToReturn, 
                             DxUint32_t       aAccessToFail,
                             NVSDebugOpType_t aOpTypeToFail,
                             DxVosFile        aLogFileHandle)
    {
        if (DX_TRUE == g_nvsDebugParams.isActive)
        {
            return DX_FAILURE;
        }

        /* TODO: Semaphore.. */


        /* Initialize the NVS debug params */

        g_nvsDebugParams.isActive         = DX_TRUE;
        g_nvsDebugParams.accessCurrent    = 0;
        g_nvsDebugParams.accessToFail     = aAccessToFail;
        g_nvsDebugParams.nvsErrorToReturn = aErrorToReturn;
        g_nvsDebugParams.opTypeToFail     = aOpTypeToFail;
        g_nvsDebugParams.logFileHandle    = aLogFileHandle;
        g_nvsDebugParams.readOpCount      = 0;
        g_nvsDebugParams.writeOpCount     = 0;

        return DX_SUCCESS;
    }/* End of NVS_DebugStart */


    /**************************************************************************
    Function: NVS_DebugStop
    ***************************************************************************/    
    DxError_t NVS_DebugStop(NVSDebugParams_t* aNvsDebugParms_ptr)
    {
        DX_VOS_FastMemCpy(aNvsDebugParms_ptr, &g_nvsDebugParams,sizeof(g_nvsDebugParams));

        DX_VOS_MemSetZero(&g_nvsDebugParams,sizeof(g_nvsDebugParams));

        g_nvsDebugParams.isActive = DX_FALSE;

        return DX_SUCCESS;
    }/* End of NVS_DebugStop */


    /**************************************************************************
    Function: NVS_DebugParamsGet
    ***************************************************************************/    
    DxError_t NVS_DebugParamsGet(NVSDebugParams_t* aNvsDebugParms_ptr)
    {
        DX_VOS_FastMemCpy(aNvsDebugParms_ptr, &g_nvsDebugParams,sizeof(g_nvsDebugParams));

        return DX_SUCCESS;
    }/* End of NVS_DebugParamsGet */


    /**************************************************************************
    Function: NVS_DebugOpFail
    ***************************************************************************/    
    DxError_t NVS_DebugOpFail(NVSDebugOpType_t aOpType)
    {
        if (DX_TRUE == g_nvsDebugParams.isActive)
        {
            if (NVS_DBG_OP_READ == aOpType)
            {
                /* increment the read operation counter */
                g_nvsDebugParams.readOpCount++;
            }
            else if (NVS_DBG_OP_WRITE == aOpType)
            {
                /* increment the write operation counter */
                g_nvsDebugParams.writeOpCount++;
            }
            else
            {
                /* increment the read & write operation counter */
                g_nvsDebugParams.readOpCount++;
                g_nvsDebugParams.writeOpCount++;
            }
                        

            if ((aOpType         == g_nvsDebugParams.opTypeToFail) ||
                (NVS_DBG_OP_BOTH == g_nvsDebugParams.opTypeToFail))
            {
                g_nvsDebugParams.accessCurrent++;
                if (g_nvsDebugParams.accessToFail == g_nvsDebugParams.accessCurrent)
                {                    
                    DX_VOS_FPrintf(g_nvsDebugParams.logFileHandle,
                                   "NVS DEBUG MODE - %s #%d returned: %X\n",
                                   (NVS_DBG_OP_READ == aOpType) ? "NVS_Read" : "NVS_Write",                    
                                   (NVS_DBG_OP_READ == aOpType) ? g_nvsDebugParams.readOpCount : g_nvsDebugParams.writeOpCount,
                                   g_nvsDebugParams.nvsErrorToReturn);
                     g_nvsDebugParams.NVSErrorWasCalld  = DX_TRUE;

                    return g_nvsDebugParams.nvsErrorToReturn;
                }
            }
        }
        return DX_SUCCESS;
    }/* End of NVS_DebugFailure */

	
#endif/* Define NVS_DEBUG_MODE_ENABLED */
